@REM *************************************************************
@REM This script installs JRE and Mirth Connect in a silent mode
@REM 
@REM Author: Harris Development Team
@REM *************************************************************
@echo off
setlocal

set JRE_INSTALLER=jre-7u9-windows-x64.exe
set MIRTH_INSTALLER=mirthconnect-2.2.1.5861.b1248-windows-x64.exe

if [%1] equ [] (
   @echo.
   @echo Missing an environment name
   @echo.
   @echo Usage: install.cmd [environment]
   @echo where environment is a name of a sub directory containing
   @echo configuration files and scripts to configure a fully 
   @echo functional Mirth Connect Server instance.
   @echo.
   @echo For instance: install.cmd local
   @echo.
   goto end
)

REM Check that we have the right binaries

set JRE_INSTALLER=%cd%\bin\%JRE_INSTALLER%
if not exist "%JRE_INSTALLER%" (
   @echo.
   @echo Missing a JRE installer "%JRE_INSTALLER%"
   @echo.
   EXIT /B 1
)

set MIRTH_INSTALLER=%cd%\bin\%MIRTH_INSTALLER%
if not exist "%MIRTH_INSTALLER%" (
   @echo.
   @echo Missing a Mirth installer "%MIRTH_INSTALLER%"
   @echo.
   EXIT /B 1
)

REM Special case: if the parameter was 'check' stop here after we checked that
REM we have the necessary binaries.
IF %1 == check GOTO END

set ENV_DIR=%cd%\env\%1

if not exist "%ENV_DIR%" (
   @echo.
   @echo No configuration files found for environment %1. This installer does not
   @echo support installation in that environment. Aborting installation.
   @echo.
   goto end
)

if not exist "%ENV_DIR%\server.properties" (
   @echo.
   @echo Missing %ENV_DIR%\server.properties
   @echo.
   goto end
)
if not exist "%ENV_DIR%\mirth.properties" (
   @echo.
   @echo Missing %ENV_DIR%\mirth.properties
   @echo.
   goto end
)

if not exist "%ENV_DIR%\sqwm.properties" (
   @echo.
   @echo Missing %ENV_DIR%\sqwm.properties
   @echo.
   goto end
)

@echo Installing %JRE_INSTALLER%
"%JRE_INSTALLER%" /s /L jre.log IEXPLORER=1 MOZILLA=1
@echo Installing Mirth Connect %MIRTH_INSTALLER% using %ENV_DIR%\server.properties
%MIRTH_INSTALLER% -q -varfile "%ENV_DIR%\server.properties" -console -Dinstall4j.keepLog=true

FOR /F "eol=; tokens=2,2 delims==" %%i IN ('findstr /i "sys.installationDir" %ENV_DIR%\server.properties') DO set sys.installationDir=%%i

@echo Copying Mirth Connect Server Properties to %sys.installationDir%\conf
copy %ENV_DIR%\*.properties "%sys.installationDir%\conf"


:end
endlocal
